Ext.data.JsonP.sol_common_forms_FileChooserVariants({"tagname":"class","name":"sol.common.forms.FileChooserVariants","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.forms.FileChooserVariants.js","href":"lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants"}],"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"version":["1.03.006"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"defaultConfig","tagname":"property","owner":"sol.common.forms.FileChooserVariants","id":"property-defaultConfig","meta":{"private":true}},{"name":"displayDiv","tagname":"property","owner":"sol.common.forms.FileChooserVariants","id":"property-displayDiv","meta":{"private":true}},{"name":"displayImage","tagname":"property","owner":"sol.common.forms.FileChooserVariants","id":"property-displayImage","meta":{"private":true}},{"name":"dragdropfile","tagname":"property","owner":"sol.common.forms.FileChooserVariants","id":"property-dragdropfile","meta":{"private":true}},{"name":"dropZone","tagname":"property","owner":"sol.common.forms.FileChooserVariants","id":"property-dropZone","meta":{"private":true}},{"name":"filePicker","tagname":"property","owner":"sol.common.forms.FileChooserVariants","id":"property-filePicker","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"webacamImage","tagname":"property","owner":"sol.common.forms.FileChooserVariants","id":"property-webacamImage","meta":{"private":true}},{"name":"webcam","tagname":"property","owner":"sol.common.forms.FileChooserVariants","id":"property-webcam","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"JS_PICTURE_CLEAR","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-JS_PICTURE_CLEAR","meta":{"private":true}},{"name":"JS_WEBCAM_SNAP","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-JS_WEBCAM_SNAP","meta":{"private":true}},{"name":"buttonMode","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-buttonMode","meta":{"private":true}},{"name":"calcLiveCrop","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-calcLiveCrop","meta":{"private":true}},{"name":"createDivsIfNoneExist","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-createDivsIfNoneExist","meta":{"private":true}},{"name":"displayImageInPage","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-displayImageInPage","meta":{"private":true}},{"name":"fileDroppedHandler","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-fileDroppedHandler","meta":{"private":true}},{"name":"fileExtOk","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-fileExtOk","meta":{"private":true}},{"name":"filePickedHandler","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-filePickedHandler","meta":{"private":true}},{"name":"filePickedInBrowser","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-filePickedInBrowser","meta":{"private":true}},{"name":"hideDropZone","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-hideDropZone","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-initialize","meta":{}},{"name":"intervalUntil","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-intervalUntil","meta":{}},{"name":"javaBrowser","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-javaBrowser","meta":{"private":true}},{"name":"merge","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-merge","meta":{"private":true}},{"name":"preconditionsFulfilled","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-preconditionsFulfilled","meta":{"private":true}},{"name":"showDropZone","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-showDropZone","meta":{"private":true}},{"name":"uploadFile","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-uploadFile","meta":{"private":true}},{"name":"uploadImage","tagname":"method","owner":"sol.common.forms.FileChooserVariants","id":"method-uploadImage","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common.forms.FileChooserVariants","short_doc":"Implements a file-chooser, drago-drop functionality (Webbrowser only) and webcam functionality for ELO wf Forms\n\nIn s...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.forms.FileChooserVariants</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants' target='_blank'>lib_sol.common.forms.FileChooserVariants.js</a></div></pre><div class='doc-contents'><p>Implements a file-chooser, drago-drop functionality (Webbrowser only) and webcam functionality for ELO wf Forms</p>\n\n<p>In some forms, you'd maybe like to let the user select a picture. And save it for later use.\nIf so, please use the 113_capturepic_webcam \"HR\"-Form as an inspiration.</p>\n\n<p>As soon as you defined your own form having all required fields, you can use the following config for initializing this class</p>\n\n<h3>Example config</h3>\n\n<pre><code>{\n  name: \"personnelphotopicker\",\n  webcamName: \"personnelphotocam\",\n  webcamConfig: {\n    javaStartupButton: \"WEBCAM_JAVA\",\n    varNameBtnReset: \"JS_WEBCAM_RESET\",\n    varNameBtnSnap: \"JS_WEBCAM_SNAP\",\n    varNameContainer: \"WEBCAM_INIT\",\n    width: 540,\n    height: 390,\n    dest_width: 720,\n    dest_height: 520,\n    crop_width: 400,\n    crop_height: 520,\n    image_format: \"jpeg\",\n    jpeg_quality: 90,\n    swfURL: \"lib_webcam.swf\",\n    fps: 45,\n    showIfNoCam: true\n  },\n  dropZoneId: \"dropZone\",\n  filePickerId: \"filePicker\",\n  accept: \"image/jpeg, image/jpg, image/png\",\n  maxSize: \"3\", //Megabyte (float values possible)\n  maskNameForRule: \"Personnel file\",\n  solTypeForRule: \"PERSONNELFILE\",\n  photoReferenceField: \"HR_PERSONNEL_PHOTO_GUID\",\n  photoReferenceFieldObjId: \"HR_PERSONNEL_PHOTO_OBJID\",\n  clearPreviewField: \"JS_PICTURE_CLEAR\",\n  filePickerField: \"JS_FILEPICKER\",\n  photoConfig: {\n    maskName: \"Personnel file document\",\n    pictureName: \"Mitarbeiterfoto\"\n  }\n}\n</code></pre>\n\n<h3>Setup</h3>\n\n<p>Add the following to your <code>Header.txt</code></p>\n\n<pre><code>function onInit() {\n  this.fcv = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.forms.FileChooserVariants\" rel=\"sol.common.forms.FileChooserVariants\" class=\"docClass\">sol.common.forms.FileChooserVariants</a>\", config);\n}\n\n// i recommend to save using these precautions, otherwise empty images might get saved\n// also, note that \"webbrowser\"-webcam pictures need to be saved using the function \"webcam.savePicture\" instead of calling \"fcv.uploadImage\" directly\nfunction nextClicked(id) {\n  return (\n    <a href=\"#!/api/sol.common.forms.Utils-method-disableCancelButtonValidation\" rel=\"sol.common.forms.Utils-method-disableCancelButtonValidation\" class=\"docClass\">sol.common.forms.Utils.disableCancelButtonValidation</a>(id, [\"sol.common.wf.node.cancel\"])\n    || (typeof this.fcv.displayImage !== \"undefined\" &amp;&amp; this.fcv.displayImage.src &amp;&amp; this.fcv.uploadImage(this.fcv.displayImage.src))\n    || ($var(config.webcamConfig.varNameContainer) &amp;&amp; this.fcv.webcam.savePicture(this.fcv.uploadImage.bind(this.fcv)));\n  );\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.03.006</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-defaultConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-property-defaultConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-property-defaultConfig' class='name expandable'>defaultConfig</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{name: &quot;filepicker&quot;, webcamName: &quot;photocam&quot;, webcamConfig: {javaStartupButton: &quot;WEBCAM_JAVA&quot;, varNameBtnReset: &quot;JS_WEBCAM_RESET&quot;, varNameBtnSnap: &quot;JS_WEBCAM_SNAP&quot;, varNameContainer: &quot;WEBCAM_INIT&quot;, width: 540, height: 390, dest_width: 720, dest_height: 520, crop_width: 400, crop_height: 520, image_format: &quot;jpeg&quot;, jpeg_quality: 90, swfURL: &quot;lib_webcam.swf&quot;, fps: 45, showIfNoCam: true}, dropZoneId: &quot;dropZone&quot;, filePickerId: &quot;filePicker&quot;, accept: &quot;image/jpeg, image/jpg, image/png&quot;, maxSize: &quot;3&quot;, photoReferenceField: &quot;&quot;, photoReferenceFieldObjId: &quot;FILEPICKER_FILE_OBJID&quot;, clearPreviewField: &quot;JS_PICTURE_CLEAR&quot;, filePickerField: &quot;JS_FILEPICKER&quot;, photoConfig: {maskName: &quot;Basic Entry&quot;, pictureName: &quot;my_file&quot;}}</code></p></div></div></div><div id='property-displayDiv' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-property-displayDiv' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-property-displayDiv' class='name expandable'>displayDiv</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>divs</p>\n</div><div class='long'><p>divs</p>\n</div></div></div><div id='property-displayImage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-property-displayImage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-property-displayImage' class='name expandable'>displayImage</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-dragdropfile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-property-dragdropfile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-property-dragdropfile' class='name expandable'>dragdropfile</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>base64 temporary stores</p>\n</div><div class='long'><p>base64 temporary stores</p>\n</div></div></div><div id='property-dropZone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-property-dropZone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-property-dropZone' class='name expandable'>dropZone</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-filePicker' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-property-filePicker' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-property-filePicker' class='name expandable'>filePicker</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-webacamImage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-property-webacamImage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-property-webacamImage' class='name expandable'>webacamImage</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-webcam' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-property-webcam' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-property-webcam' class='name expandable'>webcam</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>instruments</p>\n</div><div class='long'><p>instruments</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-JS_PICTURE_CLEAR' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-JS_PICTURE_CLEAR' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-JS_PICTURE_CLEAR' class='name expandable'>JS_PICTURE_CLEAR</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>clears / resets the captured picture ...</div><div class='long'><p>clears / resets the captured picture</p>\n</div></div></div><div id='method-JS_WEBCAM_SNAP' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-JS_WEBCAM_SNAP' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-JS_WEBCAM_SNAP' class='name expandable'>JS_WEBCAM_SNAP</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>takes a webcam-picture ...</div><div class='long'><p>takes a webcam-picture</p>\n</div></div></div><div id='method-buttonMode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-buttonMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-buttonMode' class='name expandable'>buttonMode</a>( <span class='pre'>mode</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mode</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-calcLiveCrop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-calcLiveCrop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-calcLiveCrop' class='name expandable'>calcLiveCrop</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-createDivsIfNoneExist' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-createDivsIfNoneExist' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-createDivsIfNoneExist' class='name expandable'>createDivsIfNoneExist</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-displayImageInPage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-displayImageInPage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-displayImageInPage' class='name expandable'>displayImageInPage</a>( <span class='pre'>reader, file</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>reader</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>file</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-fileDroppedHandler' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-fileDroppedHandler' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-fileDroppedHandler' class='name expandable'>fileDroppedHandler</a>( <span class='pre'>ev</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ev</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-fileExtOk' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-fileExtOk' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-fileExtOk' class='name expandable'>fileExtOk</a>( <span class='pre'>allowedTypes, fileName</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>allowedTypes</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>fileName</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-filePickedHandler' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-filePickedHandler' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-filePickedHandler' class='name expandable'>filePickedHandler</a>( <span class='pre'>e</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-filePickedInBrowser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-filePickedInBrowser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-filePickedInBrowser' class='name expandable'>filePickedInBrowser</a>( <span class='pre'>ev</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ev</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-hideDropZone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-hideDropZone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-hideDropZone' class='name expandable'>hideDropZone</a>( <span class='pre'>e</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Initialize the tools ...</div><div class='long'><p>Initialize the tools</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-intervalUntil' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-intervalUntil' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-intervalUntil' class='name expandable'>intervalUntil</a>( <span class='pre'>f, until, after, intervalTime, params</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>small wrapper around interval functions\n\nThis function is 100% decoupled from any ELO-specifics and can be used in pu...</div><div class='long'><p>small wrapper around interval functions</p>\n\n<p>This function is 100% decoupled from any ELO-specifics and can be used in pure Javascript environments</p>\n\n<p>f: function to perform work</p>\n\n<p>until: function to check if f should be run again or not</p>\n\n<p>after: function to run after until conditions were met</p>\n\n<p>intervalTime: time in ms (interval runs every x ms)</p>\n\n<pre><code>params: {\n  f: any            pass f any param you like\n  f_message:String  console.log before f is called\n  until:any   pass any any param you like\n  until_message: String  console.log before until is called\n  conditionmet_message:String  console.log if contition is met\n  after:any   pass after any param you like\n  afterafter_message:String   console.log after after was called\n  logging: Boolean    enables logging if set to true\n  maxtries: Integer     how often the f function will be executed before the interval is stopped\n  name: String          name in logger\n}\n</code></pre>\n\n<p>if the messages are defined as empty strings, no console-logging will be done.</p>\n\n<p>Of course the execution time of f and until is synchronized. f always runs before until.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>f</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>until</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>after</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>intervalTime</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>a function, which can later be used to stop the interval, if the until condition seems to never reach an end</p>\n</div></li></ul></div></div></div><div id='method-javaBrowser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-javaBrowser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-javaBrowser' class='name expandable'>javaBrowser</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-merge' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-merge' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-merge' class='name expandable'>merge</a>( <span class='pre'>custom, base, log, path, assignCallback, recursionCheck</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>custom</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>base</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>log</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>path</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>assignCallback</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>recursionCheck</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-preconditionsFulfilled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-preconditionsFulfilled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-preconditionsFulfilled' class='name expandable'>preconditionsFulfilled</a>( <span class='pre'>file</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>file</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-showDropZone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-showDropZone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-showDropZone' class='name expandable'>showDropZone</a>( <span class='pre'>e</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uploadFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-uploadFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-uploadFile' class='name expandable'>uploadFile</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>guarded file upload for nextClicked or saveClicked ...</div><div class='long'><p>guarded file upload for nextClicked or saveClicked</p>\n</div></div></div><div id='method-uploadImage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FileChooserVariants'>sol.common.forms.FileChooserVariants</span><br/><a href='source/lib_sol.common.forms.FileChooserVariants.html#sol-common-forms-FileChooserVariants-method-uploadImage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FileChooserVariants-method-uploadImage' class='name expandable'>uploadImage</a>( <span class='pre'>image</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>function can be used to upload an image ...</div><div class='long'><p>function can be used to upload an image</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>image</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div></div></div></div>","meta":{}});